/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.python.constantine.platform.Errno;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.LibCProvider;
import org.python.posix.POSIXHandler;
import org.python.posix.Solaris64FileStat;
import org.python.posix.SolarisHeapFileStat;
import org.python.posix.SolarisPasswd;
import org.python.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            return object != null ? new SolarisPasswd((Pointer)object) : null;
        }
    };

    SolarisPOSIX(String string, LibCProvider libCProvider, POSIXHandler pOSIXHandler) {
        super(string, libCProvider, pOSIXHandler);
    }

    public BaseHeapFileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisHeapFileStat(this) : new Solaris64FileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        int n = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_64_BIT ? this.libc().fstat(n, baseHeapFileStat) : this.libc().fstat64(n, baseHeapFileStat)) < 0) {
            this.handler.error(Errno.ENOENT, "" + n);
        }
        return baseHeapFileStat;
    }

    public int lchmod(String string, int n) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public FileStat lstat(String string) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().lstat(string, baseHeapFileStat) : this.libc().lstat64(string, baseHeapFileStat)) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return baseHeapFileStat;
    }

    public FileStat stat(String string) {
        BaseHeapFileStat baseHeapFileStat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().stat(string, baseHeapFileStat) : this.libc().stat64(string, baseHeapFileStat)) < 0) {
            this.handler.error(Errno.ENOENT, string);
        }
        return baseHeapFileStat;
    }
}

